/*
 * SynchroDrive.ino
 * 2021 M Nieuwenhuizen
 * 
 * Library code of the AD9833 drivcer found at: https://github.com/Billwilliams1952/AD9833-Library-Arduino
 * other libraries are standard components
 * 
 */

#include "AD9833.h"            // Include the AD9833 library
#include "LiquidCrystal_I2C.h" //Include the LCD display library


const int FNC_Pin   = 6;
const int buttonPin = 7;

int   buttonState  = LOW;
int   buttonState1 = LOW;
int   buttonState2 = LOW;
int   first        = true;
int   rpm          = 0;

//float freq33       = 50.0;  //change to 60.0 for 60 Hz countries
//float freq45       = 67.5;  //change to 81.0 for 60 Hz countries

//finetuning the frequencies (for REGA P3)

// Important note: Setting the optimal frequency with a stroboscope disc ONLY works
// 100% correct for 33.3 rpm. For 45 rpm there is ALWAYS a slight offset due to the
// limitations of the stroboscope disc.

//by adding more controls you could add a real finetuning control, but for use with a fixed
//turntable, this is sufficient
float freq33       = 49.8;  //change to 60.0 for 60 Hz countries
float freq45       = 67.3;  //change to 81.0 for 60 Hz countries

LiquidCrystal_I2C lcd(0x27,20,4);
AD9833 gen( FNC_Pin );       // Defaults to 25MHz internal reference frequency

void setup() 
{
    gen.Begin();
    
    lcd.begin();                      // initialize the lcd 
    lcd.noBacklight();

    // no output yet, first all voltages must stabilize              
    gen.ApplySignal(SINE_WAVE,REG0,freq33); 
    gen.EnableOutput(false);   // Turn ON the output - it defaults to OFF
    rpm = 0;
    
    pinMode(buttonPin, INPUT);

    //startup text in the display
    lcd.setCursor(0,0);
    lcd.print(" CABAN  digital ");
    lcd.setCursor(1,1);
    lcd.print(" initialising  ");    
    lcd.backlight();

    //wait for stabilized voltages
    delay(4000);

    //ready
    lcd.setCursor(1,1);
    lcd.print("   standby    ");    
 }

void loop() 
{ 
  //debounce  
  buttonState1 = digitalRead( buttonPin );
  delay(50); 
  buttonState2 = digitalRead( buttonPin );
  // change status if both recent measurements are the same AND they are not the same 
  // as the old button position
  if ( (buttonState1 == buttonState2 ) && ( buttonState!= buttonState2 ) )
  {
    buttonState = buttonState2; 
    // toggle the frequency
    if( buttonState == HIGH ) 
    {
      switch( rpm )
      {
        case 0: // go to 33
        { 
          gen.ApplySignal( SINE_WAVE, REG0, freq33 ); 
          gen.EnableOutput(true);   // Turn ON the output
          lcd.setCursor(1,1);
          lcd.print("speed = 33 rpm");    
          rpm = 33;
          break;       
        }
        case 33: // go to 45
        { 
          gen.ApplySignal( SINE_WAVE, REG0, freq45 ); 
          gen.EnableOutput(true);   // Turn ON the output
          lcd.setCursor(1,1);
          lcd.print("speed = 45 rpm");    
          rpm = 45;
          break;
        }
        case 45:
        default: // go to off
        { 
          gen.ApplySignal( SINE_WAVE, REG0, freq33 ); 
          gen.EnableOutput(false);   // Turn OFF the output
          lcd.setCursor(1,1);
          lcd.print("   standby    ");    
          rpm = 0;
          break;
        }
      }
    }    
  }
}
