

/*  Translates phase (psi) to group delay
/*
/*  This program reads a Dayton OmniMic text file in which the first
/*   column is frequency, the second column is amplitude response in
/*   dB, and the third column is phase in degrees. 
/*
/*   The phase is tested for being greater than 360 degrees and if it
/*   is, 360 is subtracted. The phase is converted to time at the
/*   corresponding frequency and then converted to a string and
/*   appended to the freq and amp response and the line is written to the
/*   output file. 
/*   The output file is named GDelay.txt.
/*
/*   source:  psi2dlay.c
/*  link to:  mylib.mix using medium.bat (medium memory model)
/*      run:  psi2dlay.exe
/*
*/
static char ver[14] = "1.00 - 05/15";

#include <headers.h>

#define  CR    13
#define  BS    8
#define  LTM   62
#define  RTM   60
#define  EOS   '\0'
#define  xesc  '\33'

static int	i, j, m, n, ESC, term, flag, p, bits, ret, count;
static int	savelen, flag2;
static char	inbuf[100], temp[80];
static char	t1[80], t2[80], t3[80], pnd[1] = '#';
static char	putcur[1] = '\0', filename[14], save[14], t4[80];
static char     dot[1] = '.', c, d, t5[40], t6[30], t7[60], t8[30];
static long     k;
double		freq1, freq3, phase3, u, v, z, freq, phase;
double		w, x, y, freq2, phase2, dtime, gd, phase1;
FILE		*f1, *f2;

static char     CLRSCN[5] = {'\33','[','2','J','\0'};
static char     REVVID[5] = {'\33','[','7','m','\0'};
static char     ATTOFF[5] = {'\33','[','0','m','\0'};

void screen();
void process();
void read_next();
void writerr();
void formatl(char *, int);
void find_tab1(char *);
void find_tab2(char *);


main()
	{
	flag = 3;
	flag2 = 1;
m1:	screen();			/* get input file name */
	if (ESC == 9) goto m99;
	process();			/* convert it */
m99:	exit(0);
	}

screen()
	{
	ESC = 0;
	zcrtwr(0x0000, CLRSCN);
	zcrtwr(0x0140, ver);
        zcrtwr(0x0117, "Converts Phase Angle to Time Delay");
        zcrtwr(0x1D14, "TDL Technology, Inc., Las Cruces, NM USA");
	formatl("Input file name: ", 12);
	zcrtwr(0x031B, temp);
sc1:    zcrtwr2(0x032D, "            ");
	zcrtwr2(0x032D, putcur);
	term = zcrtrd(13, 0x032D, inbuf);
	if (term == 0 && inbuf[0] == xesc) {ESC = 9; return;}
	n = strlen(inbuf);
	for (k = 0; k < n; k++)
	   {
	   inbuf[k] = toupper(inbuf[k]);
	   }
	strcpy(save, inbuf);
	strcpy(t1, inbuf);
	strcat(t1, "          ");
	left(t1, filename, 12);
	strcpy(t1, "          ");
	strcat(t1, inbuf);
	right(t1, t2, 12);
	t2[12] = EOS;
	zcrtwr2(0x032D, t2);
	f1 = fopen(filename, "r");
	if (f1 != 0) goto sc2;
	zcrtwr(0x051B, "Can't open this file");
	if (errno == 2) zcrtwr(0x061B, "File not found");
	   else {itoa(errno, t3, 10); strcpy(temp, "Error number: ");	
	   strcat(temp, t3); zcrtwr(0x061B, temp);}
	zcrtwr(0x081B, "Press any key to try again . . .");
	k = inkey();
        zcrtwr(0x051B, "                    ");
	zcrtwr(0x061B, "                                ");
	zcrtwr(0x081B, "                                ");	
	goto sc1;

sc2:    strcpy(t3, "GDelay.txt");
	strcpy(temp, "Output file name is: ");
	strcat(temp, t3);
	zcrtwr(0x0717, temp);
	f2 = fopen(t3, "w");
	strcpy(t3, "File is open for writing");
	zcrtwr(0x0817, t3);
	}


process()
	{
	ESC = 0;
	n = 0;
pr1:	ret = fgets(inbuf, 70, f1);	// read char string
	if (ret == NULL) goto pr7;	// end of file
	savelen = strlen(inbuf);	// find length of input line
	n = savelen;

pr2:	if (flag == 0) goto pr3;
	if (flag == 3)
	   {
	   left(inbuf, t1, n);
	   flag -= 1;
	   find_tab1(t1);
	   freq1 = freq;
	   freq2 = freq;
	   freq3 = freq; 

	   find_tab2(t1);
	   phase1 = phase;
	   phase2 = phase;
	   phase3 = phase;
	   goto pr3;
  	   }

	if (flag == 2)
	   {
	   left(inbuf, t1, n);
	   flag -= 1;
	   find_tab1(t1);
	   freq2 = freq;
	   freq3 = freq;

	   find_tab2(t1);
	   phase2 = phase;
	   phase3 = phase;
	   goto pr3;
	   }

	if (flag == 1)
	   {
	   left(inbuf, t1, n);
	   flag = 0;
	   find_tab1(t1);
	   freq3 = freq;

	   find_tab2(t1);
	   phase3 = phase;
	   goto pr3;
	   }

pr3:	if (flag > 0) goto pr1;


pr4:	read_next();		// read next record
	if (ESC == 9) goto pr7;	// EOF

	strcat(t4, "\t");
	strcat(t4, t7);		// unwrapped phase			
	strcat(t4, "\t");

   // *****  Calculate Group Delay  *****

	w = (phase2 - phase1) / (freq2 - freq1);

	v = (phase3 - phase2) / (freq3 - freq2);

	gd = (-1.00 * ((w + v) / 720.00)) * 1000.00;
	ftoa(gd, t6, 0, 4, 3);
	strcat(t4, t6);
pr6:	strcat(t4, "\n");
	zcrtwr(0x0E17, t4);		// new data line 
	ret = fputs(t4, f2);		// write new char string
	if (ret == -1) {writerr(); exit(0);}


	freq1 = freq2;
	freq2 =	freq3;
	freq3 = freq;		// update freq table
	
	phase1 = phase2;
	phase2 = phase3;
	phase3 = phase;		// update phase table

	goto pr4;		// loop until EOF

pr7:	fclose(f1);
	fclose(f2);
	zcrtwr(0x1019, "DONE");
	exit(0);
	}	


find_tab1(tt)		// find first tab in input string
	char *tt;
	{
	n = savelen;
	p = 0;
	k = 1;			// start at begining
ft1:	if (tt[k] == EOS) {p = -1; return;}	// empty string
	if (tt[k] == 0x09) {p = k; goto ft2;}
	k += 1;
	goto ft1;
ft2:	left(t1, t2, p);	// save frequency in freq
	freq = atof(t2);	// convert to double
	}


find_tab2(tt)		// find second tab in input string
	char *tt;
	{
	n = savelen;
	k = n - 1;		// input line length in n
ft3:	if (tt[k] == 0x09) goto ft4;
	k -= 1;
	goto ft3;
ft4:	m = n - k - 1;
	right(t1, t3, m);	// save phase angle in phase
        phase = atof(t3);	// convert to double
	left(t1, t4, k);	// save freq and amplitude in t4

	// *****  Unwrap the Phase  *****

	x = phase;
	if ((x - phase1) < -180.00) x = x + 360.00;
	if ((x - phase1) > 180.00) x = x - 360.00;
	phase = x;
	ftoa(phase, t7, 0, 4, 3);
	}


read_next()
	{
	ret = fgets(inbuf, 70, f1);	// read char string
	if (ret == NULL) goto nx1;	// end of file
	savelen = strlen(inbuf);	// find length of input line
	n = savelen;
	left(inbuf, t1, n);
	find_tab1(t1);
	left(inbuf, t1, n);
	find_tab2(t1);
	return;
nx1:	ESC = 9;
	}

writerr()
        {
        zcrtwr(0x1020, "Data file write error");
        }

formatl(bs, b)		/* format data entry line */
	char *bs;
	short b;
	{
	short j, k;
	j = 0; k = 0;
	while (bs[k] != EOS)
	   {temp[j] = bs[k]; j++; k++;}
	k = 0;
	while (REVVID[k] != EOS)
	   {temp[j] = REVVID[k]; j++; k++;}
	temp[j] = LTM;
	j += 1;
	while (b > 0) {temp[j] = ' '; j++; b--;}
	temp[j] = RTM;
	j += 1;
	k = 0;
	while (ATTOFF[k] != EOS)
	   {temp[j] = ATTOFF[k]; j++; k++;}
	temp[j] = EOS;
	}
