//===========[ enumerated types ]=========================================================

enum stateType  {StateOFF, StateDELAY, StateON};  
enum modeType   {ModeON, ModeOFF, ModeAUTO, ModeCAL, ModeOVERTEMP};

//===========[ port mapping - Arduino native ports ]======================================

#define         PortManualOn     0      // manual ON  switch input, active low
#define         PortManualOff    1      // manual OFF switch input, active low
#define         PortBiasMode     2      // low = independent bias, high = bias/balance

#define         PortP0           3      // optoisolator output, P0, active high
#define         PortP1           4      // optoisolator output, P1, active high
#define         PortLoopTime     5      // loop processing time indication
#define         PortLEDL1        6      // LED anodes (LED select)
#define         PortLEDL2        7
#define         PortLEDR1        8
#define         PortLEDR2        9
#define         PortLEDred       10     // LED cathodes (color)
#define         PortLEDgrn       11
#define         PortLEDblu       12
#define         PortLEDdebug     13     // on board LED, active low

#define         PortADCLA        A0     // bias sense points
#define         PortADCLB        A1
#define         PortADCRA        A2
#define         PortADCRB        A3
#define         PortAudio        A4     // rectified audio in
#define         PortTemp         A5     // LM34 temperature sensor


//===========[ constants ]================================================================

#define         LEDFlash         0x10   // bit mask to test for flashing LED 

